/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PacketUtil {
    public static void writeGlobalPos(FriendlyByteBuf buf, GlobalPos gPos) {
        buf.m_130085_(gPos.m_122640_().m_135782_());
        buf.m_130064_(gPos.m_122646_());
    }

    public static GlobalPos readGlobalPos(FriendlyByteBuf buf) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        BlockPos pos = buf.m_130135_();
        return GlobalPos.m_122643_((ResourceKey)worldKey, (BlockPos)pos);
    }

    @Nonnull
    public static <T extends BlockEntity> Optional<T> getBlockEntity(Player player, BlockPos pos, Class<T> cls) {
        if (player == null) {
            return ClientUtils.getOptionalClientLevel().flatMap(level -> PneumaticCraftUtils.getTileEntityAt((BlockGetter)level, pos, cls));
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof AbstractPneumaticCraftMenu) {
            AbstractPneumaticCraftMenu pncMenu = (AbstractPneumaticCraftMenu)abstractContainerMenu;
            Object te = pncMenu.te;
            if (te != null && cls.isAssignableFrom(te.getClass()) && (pos == null || te.m_58899_().equals((Object)pos))) {
                return Optional.of(te);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public static <T extends BlockEntity> Optional<T> getBlockEntity(Player player, Class<T> cls) {
        if (player.f_19853_.f_46443_) {
            throw new RuntimeException("don't call this method client side!");
        }
        return PacketUtil.getBlockEntity(player, null, cls);
    }

    public static void writeNullableBlockState(FriendlyByteBuf buf, @Nullable BlockState state) {
        if (state == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130079_(NbtUtils.m_129202_((BlockState)state));
        }
    }

    @Nullable
    public static BlockState readNullableBlockState(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            CompoundTag tag = buf.m_130260_();
            return NbtUtils.m_129241_((CompoundTag)Objects.requireNonNull(tag));
        }
        return null;
    }
}

